<?php
/**
 * Plugin Name: Bootstrap Volunteer Application
 * Plugin URI:  https://yourwebsite.com/volunteer-application
 * Description: Provides a comprehensive volunteer application form with a custom post type to store submissions for Shako Mako, client-side jQuery validation, AJAX submission, and dynamic email notifications. Requires Advanced Custom Fields (ACF) plugin (free version compatible) for data storage.
 * Version:     1.0.0
 * Requires at least: 5.2
 * Requires PHP: 8.0
 * Author:      Your Name
 * Author URI:  https://yourwebsite.com/
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: bootstrap-volunteer-application
 * Domain Path: /languages
 */

// Exit if accessed directly to prevent unauthorized access.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define plugin constants for easier path management.
define( 'VA_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'VA_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * 1. Register Custom Post Type: Volunteers
 * This CPT will store all volunteer application submissions.
 */
add_action('init', 'va_register_volunteer_cpt');
function va_register_volunteer_cpt(){
    $labels = array(
        'name'                  => _x( 'Volunteers', 'Post Type General Name', 'bootstrap-volunteer-application' ),
        'singular_name'         => _x( 'Volunteer', 'Post Type Singular Name', 'bootstrap-volunteer-application' ),
        'menu_name'             => __( 'Volunteers', 'bootstrap-volunteer-application' ),
        'name_admin_bar'        => __( 'Volunteer', 'bootstrap-volunteer-application' ),
        'archives'              => __( 'Volunteer Archives', 'bootstrap-volunteer-application' ),
        'attributes'            => __( 'Volunteer Attributes', 'bootstrap-volunteer-application' ),
        'parent_item_colon'     => __( 'Parent Volunteer:', 'bootstrap-volunteer-application' ),
        'all_items'             => __( 'All Volunteers', 'bootstrap-volunteer-application' ),
        'add_new_item'          => __( 'Add New Volunteer', 'bootstrap-volunteer-application' ),
        'add_new'               => __( 'Add New', 'bootstrap-volunteer-application' ),
        'new_item'              => __( 'New Volunteer', 'bootstrap-volunteer-application' ),
        'edit_item'             => __( 'Edit Volunteer', 'bootstrap-volunteer-application' ),
        'update_item'           => __( 'Update Volunteer', 'bootstrap-volunteer-application' ),
        'view_item'             => __( 'View Volunteer', 'bootstrap-volunteer-application' ),
        'view_items'            => __( 'View Volunteers', 'bootstrap-volunteer-application' ),
        'search_items'          => __( 'Search Volunteers', 'bootstrap-volunteer-application' ),
        'not_found'             => __( 'Not found', 'bootstrap-volunteer-application' ),
        'not_found_in_trash'    => __( 'Not found in Trash', 'bootstrap-volunteer-application' ),
        'featured_image'        => __( 'Featured Image', 'bootstrap-volunteer-application' ),
        'set_featured_image'    => __( 'Set featured image', 'bootstrap-volunteer-application' ),
        'remove_featured_image' => __( 'Remove featured image', 'bootstrap-volunteer-application' ),
        'use_featured_image'    => __( 'Use as featured image', 'bootstrap-volunteer-application' ),
        'insert_into_item'      => __( 'Insert into volunteer', 'bootstrap-volunteer-application' ),
        'uploaded_to_this_item' => __( 'Uploaded to this volunteer', 'bootstrap-volunteer-application' ),
        'items_list'            => __( 'Volunteers list', 'bootstrap-volunteer-application' ),
        'items_list_navigation' => __( 'Volunteers list navigation', 'bootstrap-volunteer-application' ),
        'filter_items_list'     => __( 'Filter volunteers list', 'bootstrap-volunteer-application' ),
    );

    $args = array(
        'label'                 => __( 'Volunteer', 'bootstrap-volunteer-application' ),
        'description'           => __( 'Volunteer application submissions from the website.', 'bootstrap-volunteer-application' ),
        'labels'                => $labels,
        'supports'              => array( 'title' ), // Using 'title' for applicant's name
        'hierarchical'          => false,
        'public'                => false, // Not publicly viewable on front-end
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 20, // Position in admin menu
        'menu_icon'             => 'dashicons-groups', // Icon for the menu item
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => false, // Not for navigation menus
        'can_export'            => true,
        'has_archive'           => false,
        'exclude_from_search'   => true,
        'publicly_queryable'    => false,
        'capability_type'       => 'post',
        'rewrite'               => false,
    );
    register_post_type('volunteer', $args);
}

/**
 * Enqueue Admin CSS & JS
 * Enqueues styles and scripts for the WordPress admin area, specifically for the settings page.
 */
add_action('admin_enqueue_scripts', 'va_admin_enqueue_assets');
function va_admin_enqueue_assets(){
    // Enqueue Bootstrap CSS for admin (optional, if needed for settings page styling)
    //wp_enqueue_style('va-admin-bootstrap-css', "https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css", array(), '5.3.6', 'all');
    // Enqueue Font Awesome for admin (optional)
    //wp_enqueue_style('va-admin-fontawesome-css', "https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css", array(), '6.7.2', 'all');
    // Add any custom admin CSS here if needed
    // wp_enqueue_style('va-admin-css', VA_PLUGIN_URL . 'assets/admin/css/admin.css', array(), '1.0.0', 'all');
}

/**
 * Enqueue Front-end CSS & JS
 * Enqueues styles and scripts for the front-end volunteer application form.
 */
add_action('wp_enqueue_scripts', 'va_frontend_enqueue_assets');
function va_frontend_enqueue_assets(){
    // Enqueue Bootstrap CSS from CDN
    //wp_enqueue_style('va-bootstrap-css', "https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css", array(), '5.3.7', 'all');
    // Enqueue Google Fonts (Montserrat)
    //wp_enqueue_style('va-google-fonts', "https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap", array(), null);
    // Enqueue custom CSS for the form (adjust path as needed if you create a separate CSS file)
    // For now, assuming it's in a 'style' directory within 'assets/wp/'.
    wp_enqueue_style('va-custom-css', VA_PLUGIN_URL . 'assets/wp/style/css/volunteer.min.css', array(), '1.0.3', 'all');

    // jQuery
    //wp_enqueue_script('va-jQuery', "https://code.jquery.com/jquery-3.7.1.min.js", array(), '3.7.1', true);
    // Enqueue Bootstrap JS bundle (contains Popper.js)
    //wp_enqueue_script('va-bootstrap-js', "https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js", array(), '5.3.7', true);
    // Enqueue custom JavaScript for form validation and AJAX submission
    wp_enqueue_script('va-form-script', VA_PLUGIN_URL . 'assets/wp/js/wp-js.js', array(), '1.0.0', true);

    // Localize script to pass AJAX URL and nonce to JavaScript
    wp_localize_script(
        'va-form-script', // Handle of the script to localize
        'va_ajax_object', // Name of the JS object in global scope
        array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
            'nonce'    => wp_create_nonce( 'volunteer_form_nonce' ), // Unique nonce for this form
            'messages' => array(
                'success'           => __( 'Thank you! Your application has been submitted successfully.', 'bootstrap-volunteer-application' ),
                'email_error'       => __( 'Your application was saved, but there was an issue sending the confirmation email. Please contact support.', 'bootstrap-volunteer-application' ),
                'error'             => __( 'There was an error submitting your application. Please ensure all fields are correctly filled and try again.', 'bootstrap-volunteer-application' ),
                'validation_error'  => __( 'Please fill in all required fields correctly.', 'bootstrap-volunteer-application' ),
                'security_error'    => __( 'Security check failed. Please try again.', 'bootstrap-volunteer-application' ),
                'submitting'        => __( 'Submitting...', 'bootstrap-volunteer-application' ),
                'days_required'     => __( 'Please select at least one day you are available.', 'bootstrap-volunteer-application' ),
                'interests_required'=> __( 'Please select at least one interest/skill or fill in the "Other" text area.', 'bootstrap-volunteer-application' ),
                'certify_required'  => __( 'You must certify that the information provided is true and complete.', 'bootstrap-volunteer-application' ),
            ),
        )
    );
}

/**
 * Shortcode to display the Volunteer Application Form.
 * Usage: [volunteer_application_form]
 */
add_shortcode('volunteer_application_form', 'va_render_volunteer_form_shortcode');
function va_render_volunteer_form_shortcode(){
    ob_start(); // Start output buffering to capture HTML

    // Display form submission messages
    if ( isset( $_GET['form_status'] ) ) {
        if ( $_GET['form_status'] == 'success' ) {
            echo '<div class="alert alert-success">' . esc_html( va_ajax_object['messages']['success'] ) . '</div>';
        } elseif ( $_GET['form_status'] == 'email_error' ) {
            echo '<div class="alert alert-warning">' . esc_html( va_ajax_object['messages']['email_error'] ) . '</div>';
        } elseif ( $_GET['form_status'] == 'error' ) {
            echo '<div class="alert alert-danger">' . esc_html( va_ajax_object['messages']['error'] ) . '</div>';
        }
    }
    ?>
    <div class="volunteer-form container pt-5 pb-5 px-0">
        <form method="post" class="bootstrap-volunteer-form__form needs-validation" novalidate>
            <div class="row">
                <h2 class="text-start"><?php _e('Volunteer Application', 'bootstrap-volunteer-application'); ?></h2>
                <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-5 col-xxl-4">
                    <!-- Placeholder image for volunteer form -->
                    <img class="w-100 img-border" src="<?php echo (VA_PLUGIN_URL . '/assets/wp/img/volunteer.jpg')?>" alt="Volunteer Image">
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg-6 col-xl-7 col-xxl-8">
                    
                    <p class="primary-text mt-4">1. <?php _e('Personal Information', 'bootstrap-volunteer-application'); ?></p>
                    <div class="row mt-2">
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <input class="form-control" type="text" name="firstname" placeholder="<?php _e('First Name', 'bootstrap-volunteer-application'); ?>" required>
                            <div class="invalid-feedback"><?php _e('Please enter your first name', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <input class="form-control" type="text" name="lastname" placeholder="<?php _e('Last Name', 'bootstrap-volunteer-application'); ?>" required>
                            <div class="invalid-feedback"><?php _e('Please enter your last name', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <input class="form-control" type="date" name="dateofbirth" placeholder="<?php _e('Date of Birth', 'bootstrap-volunteer-application'); ?>" required>
                            <div class="invalid-feedback"><?php _e('Please enter your date of birth', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <input class="form-control" type="email" name="email" placeholder="<?php _e('Email', 'bootstrap-volunteer-application'); ?>" required>
                            <div class="invalid-feedback"><?php _e('Please enter your email', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <input class="form-control" type="tel" name="phone" placeholder="<?php _e('Phone', 'bootstrap-volunteer-application'); ?>" required>
                            <div class="invalid-feedback"><?php _e('Please enter your phone', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <select class="form-select" name="contactmethod" required>
                                <option disabled selected value><?php _e('Preferred Method of Contact', 'bootstrap-volunteer-application'); ?></option>
                                <option value="Phone"><?php _e('Phone', 'bootstrap-volunteer-application'); ?></option>
                                <option value="Email"><?php _e('Email', 'bootstrap-volunteer-application'); ?></option>
                                <option value="Text Message SMS"><?php _e('Text Message SMS', 'bootstrap-volunteer-application'); ?></option>
                            </select>
                            <div class="invalid-feedback"><?php _e('Please enter your preferred method of contact', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <select class="form-select" name="country" required>
                                <option selected disabled value><?php _e('Country', 'bootstrap-volunteer-application'); ?></option>
                                <option value="Afganistan">Afghanistan</option>
                                <option value="Albania">Albania</option>
                                <option value="Algeria">Algeria</option>
                                <option value="American Samoa">American Samoa</option>
                                <option value="Andorra">Andorra</option>
                                <option value="Angola">Angola</option>
                                <option value="Anguilla">Anguilla</option>
                                <option value="Antigua & Barbuda">Antigua & Barbuda</option>
                                <option value="Argentina">Argentina</option>
                                <option value="Armenia">Armenia</option>
                                <option value="Aruba">Aruba</option>
                                <option value="Australia">Australia</option>
                                <option value="Austria">Austria</option>
                                <option value="Azerbaijan">Azerbaijan</option>
                                <option value="Bahamas">Bahamas</option>
                                <option value="Bahrain">Bahrain</option>
                                <option value="Bangladesh">Bangladesh</option>
                                <option value="Barbados">Barbados</option>
                                <option value="Belarus">Belarus</option>
                                <option value="Belgium">Belgium</option>
                                <option value="Belize">Belize</option>
                                <option value="Benin">Benin</option>
                                <option value="Bermuda">Bermuda</option>
                                <option value="Bhutan">Bhutan</option>
                                <option value="Bolivia">Bolivia</option>
                                <option value="Bonaire">Bonaire</option>
                                <option value="Bosnia & Herzegovina">Bosnia & Herzegovina</option>
                                <option value="Botswana">Botswana</option>
                                <option value="Brazil">Brazil</option>
                                <option value="British Indian Ocean Ter">British Indian Ocean Ter</option>
                                <option value="Brunei">Brunei</option>
                                <option value="Bulgaria">Bulgaria</option>
                                <option value="Burkina Faso">Burkina Faso</Burkina>
                                <option value="Burundi">Burundi</Burundi>
                                <option value="Cambodia">Cambodia</Cambodia>
                                <option value="Cameroon">Cameroon</Cameroon>
                                <option value="Canada">Canada</Canada>
                                <option value="Canary Islands">Canary Islands</Canary>
                                <option value="Cape Verde">Cape Verde</Cape>
                                <option value="Cayman Islands">Cayman Islands</Cayman>
                                <option value="Central African Republic">Central African Republic</Central>
                                <option value="Chad">Chad</Chad>
                                <option value="Channel Islands">Channel Islands</Channel>
                                <option value="Chile">Chile</Chile>
                                <option value="China">China</China>
                                <option value="Christmas Island">Christmas Island</Christmas>
                                <option value="Cocos Island">Cocos Island</Cocos>
                                <option value="Colombia">Colombia</Colombia>
                                <option value="Comoros">Comoros</Comoros>
                                <option value="Congo">Congo</Congo>
                                <option value="Cook Islands">Cook Islands</Cook>
                                <option value="Costa Rica">Costa Rica</Costa>
                                <option value="Cote DIvoire">Cote DIvoire</Cote>
                                <option value="Croatia">Croatia</Croatia>
                                <option value="Cuba">Cuba</Cuba>
                                <option value="Curaco">Curacao</Curaco>
                                <option value="Cyprus">Cyprus</Cyprus>
                                <option value="Czech Republic">Czech Republic</Czech>
                                <option value="Denmark">Denmark</Denmark>
                                <option value="Djibouti">Djibouti</Djibouti>
                                <option value="Dominica">Dominica</Dominica>
                                <option value="Dominican Republic">Dominican Republic</Dominican>
                                <option value="East Timor">East Timor</East>
                                <option value="Ecuador">Ecuador</Ecuador>
                                <option value="Egypt">Egypt</Egypt>
                                <option value="El Salvador">El Salvador</El>
                                <option value="Equatorial Guinea">Equatorial Guinea</Equatorial>
                                <option value="Eritrea">Eritrea</Eritrea>
                                <option value="Estonia">Estonia</Estonia>
                                <option value="Ethiopia">Ethiopia</Ethiopia>
                                <option value="Falkland Islands">Falkland Islands</Falkland>
                                <option value="Faroe Islands">Faroe Islands</Faroe>
                                <option value="Fiji">Fiji</Fiji>
                                <option value="Finland">Finland</Finland>
                                <option value="France">France</France>
                                <option value="French Guiana">French Guiana</French>
                                <option value="French Polynesia">French Polynesia</French>
                                <option value="French Southern Ter">French Southern Ter</French>
                                <option value="Gabon">Gabon</Gabon>
                                <option value="Gambia">Gambia</Gambia>
                                <option value="Georgia">Georgia</Georgia>
                                <option value="Germany">Germany</Germany>
                                <option value="Ghana">Ghana</Ghana>
                                <option value="Gibraltar">Gibraltar</Gibraltar>
                                <option value="Great Britain">Great Britain</Great>
                                <option value="Greece">Greece</Greece>
                                <option value="Greenland">Greenland</Greenland>
                                <option value="Grenada">Grenada</Grenada>
                                <option value="Guadeloupe">Guadeloupe</Guadeloupe>
                                <option value="Guam">Guam</Guam>
                                <option value="Guatemala">Guatemala</Guatemala>
                                <option value="Guinea">Guinea</Guinea>
                                <option value="Guyana">Guyana</Guyana>
                                <option value="Haiti">Haiti</Haiti>
                                <option value="Hawaii">Hawaii</Hawaii>
                                <option value="Honduras">Honduras</Honduras>
                                <option value="Hong Kong">Hong Kong</Hong>
                                <option value="Hungary">Hungary</Hungary>
                                <option value="Iceland">Iceland</Iceland>
                                <option value="Indonesia">Indonesia</Indonesia>
                                <option value="India">India</India>
                                <option value="Iran">Iran</Iran>
                                <option value="Iraq">Iraq</Iraq>
                                <option value="Ireland">Ireland</Ireland>
                                <option value="Isle of Man">Isle of Man</Isle>
                                <option value="Israel">Israel</Israel>
                                <option value="Italy">Italy</Italy>
                                <option value="Jamaica">Jamaica</Jamaica>
                                <option value="Japan">Japan</Japan>
                                <option value="Jordan">Jordan</Jordan>
                                <option value="Kazakhstan">Kazakhstan</Kazakhstan>
                                <option value="Kenya">Kenya</Kenya>
                                <option value="Kiribati">Kiribati</Kiribati>
                                <option value="Korea North">Korea North</Korea>
                                <option value="Korea Sout">Korea South</Korea>
                                <option value="Kuwait">Kuwait</Kuwait>
                                <option value="Kyrgyzstan">Kyrgyzstan</Kyrgyzstan>
                                <option value="Laos">Laos</Laos>
                                <option value="Latvia">Latvia</Latvia>
                                <option value="Lebanon">Lebanon</Lebanon>
                                <option value="Lesotho">Lesotho</Lesotho>
                                <option value="Liberia">Liberia</Liberia>
                                <option value="Libya">Libya</Libya>
                                <option value="Liechtenstein">Liechtenstein</Liechtenstein>
                                <option value="Lithuania">Lithuania</Lithuania>
                                <option value="Luxembourg">Luxembourg</Luxembourg>
                                <option value="Macau">Macau</Macau>
                                <option value="Macedonia">Macedonia</Macedonia>
                                <option value="Madagascar">Madagascar</Madagascar>
                                <option value="Malaysia">Malaysia</Malaysia>
                                <option value="Malawi">Malawi</Malawi>
                                <option value="Maldives">Maldives</Maldives>
                                <option value="Mali">Mali</Mali>
                                <option value="Malta">Malta</Malta>
                                <option value="Marshall Islands">Marshall Islands</Marshall>
                                <option value="Martinique">Martinique</Martinique>
                                <option value="Mauritania">Mauritania</Mauritania>
                                <option value="Mauritius">Mauritius</Mauritius>
                                <option value="Mayotte">Mayotte</Mayotte>
                                <option value="Mexico">Mexico</Mexico>
                                <option value="Midway Islands">Midway Islands</Midway>
                                <option value="Moldova">Moldova</Moldova>
                                <option value="Monaco">Monaco</Monaco>
                                <option value="Mongolia">Mongolia</Mongolia>
                                <option value="Montserrat">Montserrat</Montserrat>
                                <option value="Morocco">Morocco</Morocco>
                                <option value="Mozambique">Mozambique</Mozambique>
                                <option value="Myanmar">Myanmar</Myanmar>
                                <option value="Nambia">Nambia</Nambia>
                                <option value="Nauru">Nauru</Nauru>
                                <option value="Nepal">Nepal</Nepal>
                                <option value="Netherland Antilles">Netherland Antilles</Netherland>
                                <option value="Netherlands">Netherlands (Holland, Europe)</option>
                                <option value="Nevis">Nevis</Nevis>
                                <option value="New Caledonia">New Caledonia</New>
                                <option value="New Zealand">New Zealand</New>
                                <option value="Nicaragua">Nicaragua</Nicaragua>
                                <option value="Niger">Niger</Niger>
                                <option value="Nigeria">Nigeria</Nigeria>
                                <option value="Niue">Niue</Niue>
                                <option value="Norfolk Island">Norfolk Island</Norfolk>
                                <option value="Norway">Norway</Norway>
                                <option value="Oman">Oman</Oman>
                                <option value="Pakistan">Pakistan</Pakistan>
                                <option value="Palau Island">Palau Island</Palau>
                                <option value="Palestine">Palestine</Palestine>
                                <option value="Panama">Panama</Panama>
                                <option value="Papua New Guinea">Papua New Guinea</Papua>
                                <option value="Paraguay">Paraguay</Paraguay>
                                <option value="Peru">Peru</Peru>
                                <option value="Phillipines">Philippines</Phillipines>
                                <option value="Pitcairn Island">Pitcairn Island</Pitcairn>
                                <option value="Poland">Poland</Poland>
                                <option value="Portugal">Portugal</Portugal>
                                <option value="Puerto Rico">Puerto Rico</Puerto>
                                <option value="Qatar">Qatar</Qatar>
                                <option value="Republic of Montenegro">Republic of Montenegro</Republic>
                                <option value="Republic of Serbia">Republic of Serbia</Republic>
                                <option value="Reunion">Reunion</Reunion>
                                <option value="Romania">Romania</Romania>
                                <option value="Russia">Russia</Russia>
                                <option value="Rwanda">Rwanda</Rwanda>
                                <option value="St Barthelemy">St Barthelemy</St>
                                <option value="St Eustatius">St Eustatius</St>
                                <option value="St Helena">St Helena</St>
                                <option value="St Kitts-Nevis">St Kitts-Nevis</St>
                                <option value="St Lucia">St Lucia</St>
                                <option value="St Maarten">St Maarten</St>
                                <option value="St Pierre & Miquelon">St Pierre & Miquelon</St>
                                <option value="St Vincent & Grenadines">St Vincent & Grenadines</St>
                                <option value="Saipan">Saipan</Saipan>
                                <option value="Samoa">Samoa</Samoa>
                                <option value="Samoa American">Samoa American</Samoa>
                                <option value="San Marino">San Marino</San
                                <option value="Sao Tome & Principe">Sao Tome & Principe</Sao>
                                <option value="Saudi Arabia">Saudi Arabia</Saudi>
                                <option value="Senegal">Senegal</Senegal>
                                <option value="Seychelles">Seychelles</Seychelles>
                                <option value="Sierra Leone">Sierra Leone</Sierra>
                                <option value="Singapore">Singapore</Singapore>
                                <option value="Slovakia">Slovakia</Slovakia>
                                <option value="Slovenia">Slovenia</Slovenia>
                                <option value="Solomon Islands">Solomon Islands</Solomon>
                                <option value="Somalia">Somalia</Somalia>
                                <option value="South Africa">South Africa</South>
                                <option value="Spain">Spain</Spain>
                                <option value="Sri Lanka">Sri Lanka</Sri>
                                <option value="Sudan">Sudan</Sudan>
                                <option value="Suriname">Suriname</Suriname>
                                <option value="Swaziland">Swaziland</Swaziland>
                                <option value="Sweden">Sweden</Sweden>
                                <option value="Switzerland">Switzerland</Switzerland>
                                <option value="Syria">Syria</Syria>
                                <option value="Tahiti">Tahiti</Tahiti>
                                <option value="Taiwan">Taiwan</Taiwan>
                                <option value="Tajikistan">Tajikistan</Tajikistan>
                                <option value="Tanzania">Tanzania</Tanzania>
                                <option value="Thailand">Thailand</Thailand>
                                <option value="Togo">Togo</Togo>
                                <option value="Tokelau">Tokelau</Tokelau>
                                <option value="Tonga">Tonga</Tonga>
                                <option value="Trinidad & Tobago">Trinidad & Tobago</Trinidad>
                                <option value="Tunisia">Tunisia</Tunisia>
                                <option value="Turkey">Turkey</Turkey>
                                <option value="Turkmenistan">Turkmenistan</Turkmenistan>
                                <option value="Turks & Caicos Is">Turks & Caicos Is</Turks>
                                <option value="Tuvalu">Tuvalu</Tuvalu>
                                <option value="Uganda">Uganda</Uganda>
                                <option value="United Kingdom">United Kingdom</United>
                                <option value="Ukraine">Ukraine</Ukraine>
                                <option value="United Arab Erimates">United Arab Emirates</United>
                                <option value="United States of America">United States of America</United>
                                <option value="Uraguay">Uruguay</Uraguay>
                                <option value="Uzbekistan">Uzbekistan</Uzbekistan>
                                <option value="Vanuatu">Vanuatu</Vanuatu>
                                <option value="Vatican City State">Vatican City State</Vatican>
                                <option value="Venezuela">Venezuela</Venezuela>
                                <option value="Vietnam">Vietnam</Vietnam>
                                <option value="Virgin Islands (Brit)">Virgin Islands (Brit)</Virgin>
                                <option value="Virgin Islands (USA)">Virgin Islands (USA)</Virgin>
                                <option value="Wake Island">Wake Island</Wake>
                                <option value="Wallis & Futana Is">Wallis & Futana Is</Wallis>
                                <option value="Yemen">Yemen</Yemen>
                                <option value="Zaire">Zaire</Zaire>
                                <option value="Zambia">Zambia</Zambia>
                                <option value="Zimbabwe">Zimbabwe</Zimbabwe>
                            </select>
                            <div class="invalid-feedback"><?php _e('Please select your country', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <input class="form-control" type="text" name="state" placeholder="<?php _e('State', 'bootstrap-volunteer-application'); ?>" required>
                            <div class="invalid-feedback"><?php _e('Please enter your state', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <input class="form-control" type="text" name="city" placeholder="<?php _e('City', 'bootstrap-volunteer-application'); ?>" required>
                            <div class="invalid-feedback"><?php _e('Please enter your city', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                        <div class="12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <input class="form-control" type="text" name="zipcode" placeholder="<?php _e('Zip Code', 'bootstrap-volunteer-application'); ?>" required>
                            <div class="invalid-feedback"><?php _e('Please enter your zip code', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                    </div>

                    <p class="primary-text mt-4">2. <?php _e('Availability', 'bootstrap-volunteer-application'); ?></p>
                    <p class="mb-0"><?php _e('Days Available', 'bootstrap-volunteer-application'); ?></p>
                    <div class="row">
                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mt-2">
                            <div class="form-check days-available-group">
                                <div>
                                    <input class="form-check-input" type="checkbox" name="daysavailable[]" value="Monday" id="monday">
                                    <label class="form-check-label" for="monday"><?php _e('Monday', 'bootstrap-volunteer-application'); ?></label>
                                </div>
                                <div>
                                    <input class="form-check-input" type="checkbox" name="daysavailable[]" value="Tuesday" id="tuesday">
                                    <label class="form-check-label" for="tuesday"><?php _e('Tuesday', 'bootstrap-volunteer-application'); ?></label>
                                </div>
                                <div>
                                    <input class="form-check-input" type="checkbox" name="daysavailable[]" value="Wednesday" id="wednesday">
                                    <label class="form-check-label" for="wednesday"><?php _e('Wednesday', 'bootstrap-volunteer-application'); ?></label>
                                </div>
                                <div>
                                    <input class="form-check-input" type="checkbox" name="daysavailable[]" value="Thursday" id="thursday">
                                    <label class="form-check-label" for="thursday"><?php _e('Thursday', 'bootstrap-volunteer-application'); ?></label>
                                </div>
                                <div>
                                    <input class="form-check-input" type="checkbox" name="daysavailable[]" value="Friday" id="friday">
                                    <label class="form-check-label" for="friday"><?php _e('Friday', 'bootstrap-volunteer-application'); ?></label>
                                </div>
                                <div>
                                    <input class="form-check-input" type="checkbox" name="daysavailable[]" value="Saturday" id="saturday">
                                    <label class="form-check-label" for="saturday"><?php _e('Saturday', 'bootstrap-volunteer-application'); ?></label>
                                </div>
                                <div>
                                    <input class="form-check-input" type="checkbox" name="daysavailable[]" value="Sunday" id="sunday">
                                    <label class="form-check-label" for="sunday"><?php _e('Sunday', 'bootstrap-volunteer-application'); ?></label>
                                </div>
                            </div>
                            <div class="invalid-feedback days-available-feedback"><?php _e('Please check at least 1 day', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <select class="form-select" name="timesavailable" required>
                                <option disabled selected value><?php _e('Times Available', 'bootstrap-volunteer-application'); ?></option>
                                <option value="Morning"><?php _e('Morning', 'bootstrap-volunteer-application'); ?></option>
                                <option value="Afternoon"><?php _e('Afternoon', 'bootstrap-volunteer-application'); ?></option>
                                <option value="Evening"><?php _e('Evening', 'bootstrap-volunteer-application'); ?></option>
                            </select>
                            <div class="invalid-feedback"><?php _e('Please enter your times available', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                            <select class="form-select" name="hoursperweek" required>
                                <option disabled selected value><?php _e('Hours Per Week', 'bootstrap-volunteer-application'); ?></option>
                                <option value="1-5"><?php _e('1-5', 'bootstrap-volunteer-application'); ?></option>
                                <option value="6-10"><?php _e('6-10', 'bootstrap-volunteer-application'); ?></option>
                                <option value="11-20"><?php _e('11-20', 'bootstrap-volunteer-application'); ?></option>
                                <option value="20+"><?php _e('20+', 'bootstrap-volunteer-application'); ?></option>
                            </select>
                            <div class="invalid-feedback"><?php _e('Please enter your hours per week', 'bootstrap-volunteer-application'); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <p class="primary-text mt-4">3. <?php _e('Interests and Skills', 'bootstrap-volunteer-application'); ?></p>
                <p class="mb-0"><?php _e('What type of volunteer work are you interested in?', 'bootstrap-volunteer-application'); ?></p>
                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mt-3">
                    <div class="form-check interests-and-skills">
                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Preserving Culture and Identity" id="preservingcultureandidentity">
                            <label class="form-check-label" for="preservingcultureandidentity"><?php _e('Preserving Culture and Identity', 'bootstrap-volunteer-application'); ?></label>
                        </div>
                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Women’s Empowerment" id="womensempowerment">
                            <label class="form-check-label" for="womensempowerment"><?php _e('Women’s Empowerment', 'bootstrap-volunteer-application'); ?></label>
                        </div>
                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Youth Leadership & Mentorship" id="youthleadershipmentorship">
                            <label class="form-check-label" for="youthleadershipmentorship"><?php _e('Youth Leadership & Mentorship', 'bootstrap-volunteer-application'); ?></label>
                        </div>
                        
                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Health and wellness" id="healthandwellness">
                            <label class="form-check-label" for="healthandwellness"><?php _e('Health and wellness', 'bootstrap-volunteer-application'); ?></label>
                        </div>
                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Supporting New Comers" id="supportingnewcomers">
                            <label class="form-check-label" for="supportingnewcomers"><?php _e('Supporting New Comers', 'bootstrap-volunteer-application'); ?></label>
                        </div>
                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Civic Engagement and Advocacy" id="civicengagementandadvocacy">
                            <label class="form-check-label" for="civicengagementandadvocacy"><?php _e('Civic Engagement and Advocacy', 'bootstrap-volunteer-application'); ?></label>
                        </div>

                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Changing Narratives and Building Bridges" id="changingnarrativesandbuildingbridges">
                            <label class="form-check-label" for="changingnarrativesandbuildingbridges"><?php _e('Changing Narratives and Building Bridges', 'bootstrap-volunteer-application'); ?></label>
                        </div>
                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Social Media" id="socialmedia">
                            <label class="form-check-label" for="socialmedia"><?php _e('Social Media', 'bootstrap-volunteer-application'); ?></label>
                        </div>
                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Administrative Tasks" id="administrativetasks">
                            <label class="form-check-label" for="administrativetasks"><?php _e('Administrative Tasks', 'bootstrap-volunteer-application'); ?></label>
                        </div>

                        <div>
                            <input class="form-check-input" type="checkbox" name="interestsandskills[]" value="Community Outreach" id="communityoutreach">
                            <label class="form-check-label" for="communityoutreach"><?php _e('Community Outreach', 'bootstrap-volunteer-application'); ?></label>
                        </div>
                        <div>
                            <input class="form-check-input" type="checkbox" name="fundraising" id="fundraising">
                            <label class="form-check-label" for="fundraising"><?php _e('Fundraising', 'bootstrap-volunteer-application'); ?></label>
                        </div>
                    </div>
                    <div>
                        <label for="other"><?php _e('Other', 'bootstrap-volunteer-application'); ?></label>
                        <textarea id="other" name="otherinterests" class="form-control"></textarea>
                    </div>
                    <div class="invalid-feedback interests-skills-feedback"><?php _e('Please check at least 1 interest/skill or fill in the "Other" text area', 'bootstrap-volunteer-application'); ?></div>
                    
                    <div class="mt-3">
                        <label for="relevantskills"><?php _e('List any relevant skills, experience, or languages spoken', 'bootstrap-volunteer-application'); ?></label>
                        <textarea id="relevantskills" name="relevantskills" class="form-control" required></textarea>
                        <div class="invalid-feedback"><?php _e('Please list any relevant skills, experience, or languages spoken', 'bootstrap-volunteer-application'); ?></div>
                    </div>
                    <div class="mt-3">
                        <label for="whyvolunteer"><?php _e('Why do you want to volunteer with Shako Mako?', 'bootstrap-volunteer-application'); ?></label>
                        <textarea id="whyvolunteer" name="whyvolunteer" class="form-control" required></textarea>
                        <div class="invalid-feedback"><?php _e('Please enter why do you want to volunteer with Shako Mako?', 'bootstrap-volunteer-application'); ?></div>
                    </div>
                </div>
            </div>

            <div class="row">
                <p class="primary-text mt-4">4. <?php _e('Emergency Contact', 'bootstrap-volunteer-application'); ?></p>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="text" name="emergencyfullname" placeholder="<?php _e('Full Name', 'bootstrap-volunteer-application'); ?>" required>
                    <div class="invalid-feedback"><?php _e('Please enter your emergency contact full name', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="text" name="emergencyrelationship" placeholder="<?php _e('Relationship', 'bootstrap-volunteer-application'); ?>" required>
                    <div class="invalid-feedback"><?php _e('Please enter your emergency contact relationship', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="tel" name="emergencyphone" placeholder="<?php _e('Emergency Phone', 'bootstrap-volunteer-application'); ?>" required>
                    <div class="invalid-feedback"><?php _e('Please enter your emergency contact phone', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="email" name="emergencyemail" placeholder="<?php _e('Emergency Email', 'bootstrap-volunteer-application'); ?>" required>
                    <div class="invalid-feedback"><?php _e('Please enter your emergency contact email', 'bootstrap-volunteer-application'); ?></div>
                </div>
            </div>

            <div class="row">
                <p class="primary-text mt-4">5. <?php _e('References (Optional but Recommended)', 'bootstrap-volunteer-application'); ?></p>
                <p class="mb-0"><?php _e('Reference 1:', 'bootstrap-volunteer-application'); ?></p>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="text" name="reference1fullname" placeholder="<?php _e('Full Name', 'bootstrap-volunteer-application'); ?>">
                    <div class="invalid-feedback"><?php _e('Please enter your Reference full name', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="text" name="reference1relationship" placeholder="<?php _e('Relationship', 'bootstrap-volunteer-application'); ?>">
                    <div class="invalid-feedback"><?php _e('Please enter your Reference relationship', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="tel" name="reference1phone" placeholder="<?php _e('Phone', 'bootstrap-volunteer-application'); ?>">
                    <div class="invalid-feedback"><?php _e('Please enter your Reference phone', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="email" name="reference1email" placeholder="<?php _e('Email', 'bootstrap-volunteer-application'); ?>">
                    <div class="invalid-feedback"><?php _e('Please enter your Reference email', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <p class="mt-3 mb-0"><?php _e('Reference 2:', 'bootstrap-volunteer-application'); ?></p>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="text" name="reference2fullname" placeholder="<?php _e('Full Name', 'bootstrap-volunteer-application'); ?>">
                    <div class="invalid-feedback"><?php _e('Please enter your Reference full name', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="text" name="reference2relationship" placeholder="<?php _e('Relationship', 'bootstrap-volunteer-application'); ?>">
                    <div class="invalid-feedback"><?php _e('Please enter your Reference relationship', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="tel" name="reference2phone" placeholder="<?php _e('Phone', 'bootstrap-volunteer-application'); ?>">
                    <div class="invalid-feedback"><?php _e('Please enter your Reference phone', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-6 col-md-6 col-lg-3 col-xl-3 col-xxl-3 mt-3">
                    <input class="form-control" type="email" name="reference2email" placeholder="<?php _e('Email', 'bootstrap-volunteer-application'); ?>">
                    <div class="invalid-feedback"><?php _e('Please enter your Reference email', 'bootstrap-volunteer-application'); ?></div>
                </div>
            </div>

            <div class="row">
                <p class="primary-text mt-4">6. <?php _e('Additional Information', 'bootstrap-volunteer-application'); ?></p>
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                    <select class="form-select" name="howdidyouhear" required>
                        <option disabled selected value><?php _e('How did you hear about Shako Mako?', 'bootstrap-volunteer-application'); ?></option>
                        <option value="Google Search"><?php _e('Google Search', 'bootstrap-volunteer-application'); ?></option>
                        <option value="Social Media"><?php _e('Social Media', 'bootstrap-volunteer-application'); ?></option>
                        <option value="Word of Mouth"><?php _e('Word of Mouth', 'bootstrap-volunteer-application'); ?></option>
                    </select>
                    <div class="invalid-feedback"><?php _e('Please enter how did you hear about Shako Mako?', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-2">
                    <select class="form-select" name="areyou18orolder" required>
                        <option disabled selected value><?php _e('Are you 18 or older?', 'bootstrap-volunteer-application'); ?></option>
                        <option value="Yes"><?php _e('Yes', 'bootstrap-volunteer-application'); ?></option>
                        <option value="No"><?php _e('No', 'bootstrap-volunteer-application'); ?></option>
                    </select>
                    <div class="invalid-feedback"><?php _e('Please enter are you 18 or older?', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mt-3">
                    <select class="form-select" name="backgroundcheck" required>
                        <option disabled selected value><?php _e('Do you consent to a background check if required?', 'bootstrap-volunteer-application'); ?></option>
                        <option value="Yes"><?php _e('Yes', 'bootstrap-volunteer-application'); ?></option>
                        <option value="No"><?php _e('No', 'bootstrap-volunteer-application'); ?></option>
                    </select>
                    <div class="invalid-feedback"><?php _e('Please enter do you consent to a background check if required?', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mt-3">
                    <label for="medicalconditions"><?php _e('Do you have any medical conditions or physical limitations we should be aware of?', 'bootstrap-volunteer-application'); ?></label>
                    <textarea id="medicalconditions" name="medicalconditions" class="form-control" required></textarea>
                    <div class="invalid-feedback"><?php _e('Please enter do you have any medical conditions or physical limitations we should be aware of?', 'bootstrap-volunteer-application'); ?></div>
                </div>
            </div>

            <div class="row">
                <p class="primary-text mt-4">7. <?php _e('Agreement and Signature', 'bootstrap-volunteer-application'); ?></p>
                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mt-2">
                    <input class="form-check-input" type="checkbox" name="certifythattheinformationprovidedistrue" id="certifythattheinformationprovidedistrue" required>
                    <label style="padding-top: 2px;max-width:80%;" for="certifythattheinformationprovidedistrue"><?php _e('I certify that the information provided is true and complete to the best of my knowledge.', 'bootstrap-volunteer-application'); ?></label>
                    <div class="invalid-feedback certify-feedback"><?php _e('Please check the I certify that the information provided is true and complete to the best of my knowledge', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-3">
                    <input class="form-control" type="text" name="signature" placeholder="<?php _e('Signature', 'bootstrap-volunteer-application'); ?>" required>
                    <div class="invalid-feedback"><?php _e('Please enter your Signature', 'bootstrap-volunteer-application'); ?></div>
                </div>
                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mt-3">
                    <input class="form-control" type="date" name="applicationsubmissiondate" placeholder="<?php _e('Application Submission Date', 'bootstrap-volunteer-application'); ?>" required readonly>
                    <div class="invalid-feedback"><?php _e('Please enter Application Submission Date', 'bootstrap-volunteer-application'); ?></div>
                </div>
            </div>
            <div class="row justify-content-center mt-3">
                <button class="btn btn-primary w-10" type="submit" name="submit_volunteer_form"><?php _e('Submit', 'bootstrap-volunteer-application'); ?></button>
            </div>
            <div class="va-form-messages text-center mt-3">
                <!-- AJAX messages will be displayed here -->
            </div>
        </form>
    </div>
    <?php
    return ob_get_clean(); // Return the buffered content
}

/**
 * Handle AJAX form submission for the volunteer application form.
 * This function processes the submitted data, saves it to the 'volunteer' CPT
 * using ACF, and sends email notifications.
 */
add_action('wp_ajax_va_submit_volunteer_form', 'va_handle_ajax_form_submission');
add_action('wp_ajax_nopriv_va_submit_volunteer_form', 'va_handle_ajax_form_submission');
function va_handle_ajax_form_submission() {
    // Verify nonce for security.
    if ( ! isset( $_POST['volunteer_form_nonce_field'] ) || ! wp_verify_nonce( $_POST['volunteer_form_nonce_field'], 'volunteer_form_nonce' ) ) {
        wp_send_json_error( array( 'message' => __( 'Security check failed. Please try again.', 'bootstrap-volunteer-application' ) ) );
        wp_die();
    }

    // Check if ACF is active. This plugin relies heavily on ACF.
    if ( ! function_exists( 'update_field' ) ) {
        wp_send_json_error( array( 'message' => __( 'Advanced Custom Fields plugin is not active. Please install and activate it.', 'bootstrap-volunteer-application' ) ) );
        wp_die();
    }

    // Sanitize and validate inputs.
    $firstname                  = sanitize_text_field( $_POST['firstname'] );
    $lastname                   = sanitize_text_field( $_POST['lastname'] );
    $dateofbirth                = sanitize_text_field( $_POST['dateofbirth'] );
    $email                      = sanitize_email( $_POST['email'] );
    $phone                      = sanitize_text_field( $_POST['phone'] );
    $contactmethod              = sanitize_text_field( $_POST['contactmethod'] );
    $country                    = sanitize_text_field( $_POST['country'] );
    $state                      = sanitize_text_field( $_POST['state'] );
    $city                       = sanitize_text_field( $_POST['city'] );
    $zipcode                    = sanitize_text_field( $_POST['zipcode'] );
    $daysavailable              = isset( $_POST['daysavailable'] ) ? array_map( 'sanitize_text_field', (array) $_POST['daysavailable'] ) : array();
    $timesavailable             = sanitize_text_field( $_POST['timesavailable'] );
    $hoursperweek               = sanitize_text_field( $_POST['hoursperweek'] );
    $interestsandskills         = isset( $_POST['interestsandskills'] ) ? array_map( 'sanitize_text_field', (array) $_POST['interestsandskills'] ) : array();
    $otherinterests             = sanitize_textarea_field( $_POST['otherinterests'] );
    $relevantskills             = sanitize_textarea_field( $_POST['relevantskills'] );
    $whyvolunteer               = sanitize_textarea_field( $_POST['whyvolunteer'] );
    $emergencyfullname          = sanitize_text_field( $_POST['emergencyfullname'] );
    $emergencyrelationship      = sanitize_text_field( $_POST['emergencyrelationship'] );
    $emergencyphone             = sanitize_text_field( $_POST['emergencyphone'] );
    $emergencyemail             = sanitize_email( $_POST['emergencyemail'] );
    $reference1fullname         = sanitize_text_field( $_POST['reference1fullname'] );
    $reference1relationship     = sanitize_text_field( $_POST['reference1relationship'] );
    $reference1phone            = sanitize_text_field( $_POST['reference1phone'] );
    $reference1email            = sanitize_email( $_POST['reference1email'] );
    $reference2fullname         = sanitize_text_field( $_POST['reference2fullname'] );
    $reference2relationship     = sanitize_text_field( $_POST['reference2relationship'] );
    $reference2phone            = sanitize_text_field( $_POST['reference2phone'] );
    $reference2email            = sanitize_email( $_POST['reference2email'] );
    $howdidyouhear              = sanitize_text_field( $_POST['howdidyouhear'] );
    $areyou18orolder            = sanitize_text_field( $_POST['areyou18orolder'] );
    $backgroundcheck            = sanitize_text_field( $_POST['backgroundcheck'] );
    $medicalconditions          = sanitize_textarea_field( $_POST['medicalconditions'] );
    $certifythattheinformationprovidedistrue = isset( $_POST['certifythattheinformationprovidedistrue'] ) ? 'Yes' : 'No';
    $signature                  = sanitize_text_field( $_POST['signature'] );
    $applicationsubmissiondate  = sanitize_text_field( $_POST['applicationsubmissiondate'] ); // Already set by JS

    // Server-side validation (basic checks, more detailed validation is done client-side by JS)
    if ( empty( $firstname ) || empty( $lastname ) || empty( $dateofbirth ) || ! is_email( $email ) || empty( $phone ) || empty( $contactmethod ) || empty( $country ) || empty( $state ) || empty( $city ) || empty( $zipcode ) || empty( $timesavailable ) || empty( $hoursperweek ) || empty( $relevantskills ) || empty( $whyvolunteer ) || empty( $emergencyfullname ) || empty( $emergencyrelationship ) || empty( $emergencyphone ) || ! is_email( $emergencyemail ) || empty( $howdidyouhear ) || empty( $areyou18orolder ) || empty( $backgroundcheck ) || empty( $medicalconditions ) || $certifythattheinformationprovidedistrue === 'No' || empty( $signature ) || empty( $applicationsubmissiondate ) ) {
        wp_send_json_error( array( 'message' => __( 'Please fill in all required fields correctly.', 'bootstrap-volunteer-application' ) ) );
        wp_die();
    }

    // Specific validation for 'Days Available'
    if ( empty( $daysavailable ) ) {
        wp_send_json_error( array( 'message' => __( 'Please select at least one day you are available.', 'bootstrap-volunteer-application' ) ) );
        wp_die();
    }

    // Specific validation for 'Interests and Skills' or 'Other'
    if ( empty( $interestsandskills ) && empty( $otherinterests ) ) {
        wp_send_json_error( array( 'message' => __( 'Please select at least one interest/skill or fill in the "Other" text area.', 'bootstrap-volunteer-application' ) ) );
        wp_die();
    }

    // Prepare post data for the new custom post type entry.
    $post_data = array(
        'post_title'    => sprintf( __( 'Application from %s %s', 'bootstrap-volunteer-application' ), $firstname, $lastname ), // Changed title to use full name
        'post_status'   => 'publish',
        'post_type'     => 'volunteer',
    );

    // Insert the new post into the WordPress database.
    $post_id = wp_insert_post( $post_data );

    if ( ! is_wp_error( $post_id ) ) {
        // Save custom fields using Advanced Custom Fields (ACF).
        // The ACF field names are explicitly defined in the plugin How To Use Page.
        update_field( 'volunteer_firstname', $firstname, $post_id );
        update_field( 'volunteer_lastname', $lastname, $post_id );
        update_field( 'volunteer_date_of_birth', $dateofbirth, $post_id );
        update_field( 'volunteer_email', $email, $post_id );
        update_field( 'volunteer_phone', $phone, $post_id );
        update_field( 'volunteer_contact_method', $contactmethod, $post_id );
        update_field( 'volunteer_country', $country, $post_id );
        update_field( 'volunteer_state', $state, $post_id );
        update_field( 'volunteer_city', $city, $post_id );
        update_field( 'volunteer_zipcode', $zipcode, $post_id );
        update_field( 'volunteer_days_available', $daysavailable, $post_id ); // ACF checkbox field
        update_field( 'volunteer_times_available', $timesavailable, $post_id );
        update_field( 'volunteer_hours_per_week', $hoursperweek, $post_id );
        update_field( 'volunteer_interests_skills', $interestsandskills, $post_id ); // ACF checkbox field
        update_field( 'volunteer_other_interests', $otherinterests, $post_id );
        update_field( 'volunteer_relevant_skills', $relevantskills, $post_id );
        update_field( 'volunteer_why_volunteer', $whyvolunteer, $post_id );
        update_field( 'volunteer_emergency_fullname', $emergencyfullname, $post_id );
        update_field( 'volunteer_emergency_relationship', $emergencyrelationship, $post_id );
        update_field( 'volunteer_emergency_phone', $emergencyphone, $post_id );
        update_field( 'volunteer_emergency_email', $emergencyemail, $post_id );
        update_field( 'volunteer_reference1_fullname', $reference1fullname, $post_id );
        update_field( 'volunteer_reference1_relationship', $reference1relationship, $post_id );
        update_field( 'volunteer_reference1_phone', $reference1phone, $post_id );
        update_field( 'volunteer_reference1_email', $reference1email, $post_id );
        update_field( 'volunteer_reference2_fullname', $reference2fullname, $post_id );
        update_field( 'volunteer_reference2_relationship', $reference2relationship, $post_id );
        update_field( 'volunteer_reference2_phone', $reference2phone, $post_id );
        update_field( 'volunteer_reference2_email', $reference2email, $post_id );
        update_field( 'volunteer_how_did_you_hear', $howdidyouhear, $post_id );
        update_field( 'volunteer_age_18_or_older', $areyou18orolder, $post_id );
        update_field( 'volunteer_background_check_consent', $backgroundcheck, $post_id );
        update_field( 'volunteer_medical_conditions', $medicalconditions, $post_id );
        // Removed: update_field( 'volunteer_certification', $certifythattheinformationprovidedistrue, $post_id );
        update_field( 'volunteer_signature', $signature, $post_id );
        update_field( 'volunteer_submission_date', $applicationsubmissiondate, $post_id );

        // Retrieve admin email from WordPress options (set via new settings page)
        $admin_email_recipient = get_option( 'va_admin_email_recipient', get_option( 'admin_email' ) ); // Fallback to WP admin email

        $site_name   = get_bloginfo( 'name' );

        /**
         * Send Admin Notification Email
         */
        $to_admin = $admin_email_recipient;
        $subject_admin = sprintf( __( 'New Volunteer Application from %s %s', 'bootstrap-volunteer-application' ), $firstname, $lastname );
        $message_admin = '<p>' . __( 'You have received a new volunteer application:', 'bootstrap-volunteer-application' ) . '</p>';
        $message_admin .= '<ul>';
        $message_admin .= '<li><strong>' . __( 'Applicant Name:', 'bootstrap-volunteer-application' ) . '</strong> ' . esc_html( $firstname . ' ' . $lastname ) . '</li>';
        $message_admin .= '<li><strong>' . __( 'Email:', 'bootstrap-volunteer-application' ) . '</strong> ' . esc_html( $email ) . '</li>';
        $message_admin .= '<li><strong>' . __( 'Phone:', 'bootstrap-volunteer-application' ) . '</strong> ' . esc_html( $phone ) . '</li>';
        $message_admin .= '<li><strong>' . __( 'Submission Date:', 'bootstrap-volunteer-application' ) . '</strong> ' . esc_html( $applicationsubmissiondate ) . '</li>';
        $message_admin .= '</ul>';
        $message_admin .= '<p>' . sprintf( __( 'View the full application in WordPress admin: %s', 'bootstrap-volunteer-application' ), get_edit_post_link( $post_id ) ) . '</p>';
        $headers_admin = array( 'Content-Type: text/html; charset=UTF-8', 'From: ' . $site_name . ' <' . $admin_email_recipient . '>' );
        $mail_sent_admin = wp_mail( $to_admin, $subject_admin, $message_admin, $headers_admin );

        /**
         * Send User Confirmation Email
         */
        $to_user = $email;
        $subject_user = sprintf( __( 'Thank you for your Volunteer Application to %s', 'bootstrap-volunteer-application' ), $site_name );
        $message_user = '<p>' . sprintf( __( 'Hello %s,', 'bootstrap-volunteer-application' ), esc_html( $firstname ) ) . '</p>';
        $message_user .= '<p>' . __( 'Thank you for your interest in volunteering with us! We have received your application and will review it shortly.', 'bootstrap-volunteer-application' ) . '</p>';
        $message_user .= '<p>' . __( 'Here is a summary of your submission:', 'bootstrap-volunteer-application' ) . '</p>';
        $message_user .= '<ul>';
        $message_user .= '<li><strong>' . __( 'Submitted On:', 'bootstrap-volunteer-application' ) . '</strong> ' . esc_html( $applicationsubmissiondate ) . '</li>';
        $message_user .= '<li><strong>' . __( 'Preferred Contact Method:', 'bootstrap-volunteer-application' ) . '</strong> ' . esc_html( $contactmethod ) . '</li>';
        $message_user .= '<li><strong>' . __( 'Days Available:', 'bootstrap-volunteer-application' ) . '</strong> ' . esc_html( implode(', ', $daysavailable) ) . '</li>';
        $message_user .= '<li><strong>' . __( 'Why you want to volunteer:', 'bootstrap-volunteer-application' ) . '</strong><br>' . wp_kses_post( nl2br( $whyvolunteer ) ) . '</li>';
        $message_user .= '</ul>';
        $message_user .= '<p>' . sprintf( __( 'Best regards,<br>%s Team', 'bootstrap-volunteer-application' ), $site_name ) . '</p>';
        $headers_user = array( 'Content-Type: text/html; charset=UTF-8', 'From: ' . $site_name . ' <' . $admin_email_recipient . '>' );
        $mail_sent_user = wp_mail( $to_user, $subject_user, $message_user, $headers_user );

        // Determine final response based on email sending status
        if ( ! $mail_sent_admin || ! $mail_sent_user ) {
            error_log( 'VA Plugin: One or both emails failed to send for post ID ' . $post_id );
            wp_send_json_success( array( 'message' => __( 'Your application was saved, but there was an issue sending one or more confirmation emails. Please contact support.', 'bootstrap-volunteer-application' ), 'type' => 'warning' ) );
        } else {
            wp_send_json_success( array( 'message' => __( 'Thank you! Your application has been submitted successfully.', 'bootstrap-volunteer-application' ), 'type' => 'success' ) );
        }

    } else {
        wp_send_json_error( array( 'message' => __( 'There was an error saving your application. Please try again.', 'bootstrap-volunteer-application' ) ) );
    }

    wp_die(); // Always die in AJAX handlers.
}

/**
 * Add custom columns to the 'Volunteers' list table in the WordPress admin.
 */
add_filter('manage_volunteer_posts_columns', 'va_add_volunteer_columns');
function va_add_volunteer_columns( $columns ) {
    $new_columns = array(
        'volunteer_email'    => __( 'Email', 'bootstrap-volunteer-application' ),
        'volunteer_phone'    => __( 'Phone', 'bootstrap-volunteer-application' ),
        'volunteer_country'  => __( 'Country', 'bootstrap-volunteer-application' ),
        'volunteer_submission_date' => __( 'Submission Date', 'bootstrap-volunteer-application' ),
    );

    // Insert new columns after the 'title' column.
    $offset = array_search( 'title', array_keys( $columns ) ) + 1;
    $columns = array_slice( $columns, 0, $offset, true ) + $new_columns + array_slice( $columns, $offset, null, true );

    return $columns;
}

/**
 * Populate custom columns in the 'Volunteers' list table.
 */
add_action('manage_volunteer_posts_custom_column', 'va_populate_volunteer_columns', 10, 2);
function va_populate_volunteer_columns( $column, $post_id ) {
    // Ensure ACF is active before trying to get fields.
    if ( ! function_exists( 'get_field' ) ) {
        echo __( 'ACF not active', 'bootstrap-volunteer-application' );
        return;
    }

    switch ( $column ) {
        case 'volunteer_email':
            echo esc_html( get_field( 'volunteer_email', $post_id ) );
            break;
        case 'volunteer_phone':
            echo esc_html( get_field( 'volunteer_phone', $post_id ) );
            break;
        case 'volunteer_country':
            echo esc_html( get_field( 'volunteer_country', $post_id ) );
            break;
        case 'volunteer_submission_date':
            echo esc_html( get_field( 'volunteer_submission_date', $post_id ) );
            break;
    }
}

/**
 * Add new submenu pages under the 'Volunteers' CPT.
 */
add_action('admin_menu', 'va_add_settings_pages');
function va_add_settings_pages() {
    // Add Email Settings page
    add_submenu_page(
        'edit.php?post_type=volunteer', // Parent slug (our custom post type)
        __('Volunteer Settings', 'bootstrap-volunteer-application'), // Page title
        __('Email Settings', 'bootstrap-volunteer-application'), // Menu title
        'manage_options', // Capability required to access the page
        'va-settings', // Menu slug
        'va_settings_page_content' // Callback function to display the page content
    );

    // Add How To Use page
    add_submenu_page(
        'edit.php?post_type=volunteer', // Parent slug (our custom post type)
        __('How To Use Volunteer Form', 'bootstrap-volunteer-application'), // Page title
        __('How To Use', 'bootstrap-volunteer-application'), // Menu title
        'manage_options', // Capability required to access the page
        'va-how-to-use', // Menu slug
        'va_how_to_use_page_content' // Callback function to display the page content
    );
}

/**
 * Register settings for the plugin's admin page.
 */
add_action('admin_init', 'va_register_settings');
function va_register_settings() {
    // Register a new setting for our plugin
    register_setting(
        'va_settings_group', // Option group
        'va_admin_email_recipient', // Option name (this is where the email will be stored)
        'sanitize_email' // Sanitize callback function
    );

    // Add a settings section for email settings
    add_settings_section(
        'va_email_settings_section', // ID
        __('Admin Email Notification', 'bootstrap-volunteer-application'), // Title
        'va_email_settings_section_callback', // Callback for section content
        'va-settings' // Page slug
    );

    // Add a settings field
    add_settings_field(
        'va_admin_email_field', // ID
        __('Recipient Email', 'bootstrap-volunteer-application'), // Title
        'va_admin_email_field_callback', // Callback for field content
        'va-settings', // Page slug
        'va_email_settings_section', // Section ID
        array(
            'label_for' => 'va_admin_email_recipient',
            'class'     => 'va-admin-email-row',
            'name'      => 'va_admin_email_recipient',
        )
    );
}

/**
 * Callback for the email settings section content.
 */
function va_email_settings_section_callback() {
    echo '<p>' . __('Enter the email address where you want to receive volunteer application submissions.', 'bootstrap-volunteer-application') . '</p>';
}

/**
 * Callback for the email settings field content.
 */
function va_admin_email_field_callback($args) {
    // Get the current value of the option, with a fallback to the WordPress admin email.
    $email = get_option($args['name'], get_option('admin_email'));
    ?>
    <input type="email" id="<?php echo esc_attr($args['name']); ?>" name="<?php echo esc_attr($args['name']); ?>" value="<?php echo esc_attr($email); ?>" class="regular-text" placeholder="<?php esc_attr_e('e.g., your-email@example.com', 'bootstrap-volunteer-application'); ?>" />
    <p class="description">
        <?php _e('This email address will receive all new volunteer application submissions. If left empty, the default WordPress admin email will be used.', 'bootstrap-volunteer-application'); ?>
    </p>
    <?php
}

/**
 * Display the content of the plugin's Email Settings page.
 */
function va_settings_page_content() {
    ?>
    <div class="wrap">
        <h1><?php _e('Bootstrap Volunteer Application Settings', 'bootstrap-volunteer-application'); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields('va_settings_group'); // Output security fields for the settings group
            do_settings_sections('va-settings'); // Output settings sections and fields
            submit_button(); // Output save button
            ?>
        </form>
    </div>
    <?php
}

/**
 * Display the content of the plugin's "How To Use" page.
 */
function va_how_to_use_page_content() {
    ?>
    <div class="wrap">
        <h1><?php _e('How To Use Bootstrap Volunteer Application Form', 'bootstrap-volunteer-application'); ?></h1>
        <p><?php _e('To display the volunteer application form on any page or post, simply use the following shortcode:', 'bootstrap-volunteer-application'); ?></p>
        <pre><code>[volunteer_application_form]</code></pre>
        <p><?php _e('Paste this shortcode into the content editor of the desired page or post.', 'bootstrap-volunteer-application'); ?></p>
        
        <h2><?php _e('Required Advanced Custom Fields (ACF) Setup', 'bootstrap-volunteer-application'); ?></h2>
        <p><?php _e('This plugin relies on the Advanced Custom Fields (ACF) plugin to store volunteer application data. Please ensure ACF is installed and active.', 'bootstrap-volunteer-application'); ?></p>
        <p><?php _e('You need to create a Field Group in ACF and assign it to the "Volunteer" Custom Post Type. Below are the exact field names (keys) and recommended types you should use:', 'bootstrap-volunteer-application'); ?></p>
        
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php _e('ACF Field Name (Key)', 'bootstrap-volunteer-application'); ?></th>
                    <th><?php _e('Recommended Field Type', 'bootstrap-volunteer-application'); ?></th>
                    <th><?php _e('Description', 'bootstrap-volunteer-application'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr><td><code>volunteer_firstname</code></td><td>Text</td><td>Applicant's first name.</td></tr>
                <tr><td><code>volunteer_lastname</code></td><td>Text</td><td>Applicant's last name.</td></tr>
                <tr><td><code>volunteer_date_of_birth</code></td><td>Date Picker</td><td>Applicant's date of birth.</td></tr>
                <tr><td><code>volunteer_email</code></td><td>Email</td><td>Applicant's email address.</td></tr>
                <tr><td><code>volunteer_phone</code></td><td>Text</td><td>Applicant's phone number.</td></tr>
                <tr><td><code>volunteer_contact_method</code></td><td>Select</td><td>Preferred method of contact (e.g., Phone, Email, Text Message SMS).</td></tr>
                <tr><td><code>volunteer_country</code></td><td>Select</td><td>Applicant's country.</td></tr>
                <tr><td><code>volunteer_state</code></td><td>Text</td><td>Applicant's state.</td></tr>
                <tr><td><code>volunteer_city</code></td><td>Text</td><td>Applicant's city.</td></tr>
                <tr><td><code>volunteer_zipcode</code></td><td>Text</td><td>Applicant's zip code.</td></tr>
                <tr><td><code>volunteer_days_available</code></td><td>Checkbox</td><td>Days the applicant is available (e.g., Monday, Tuesday).</td></tr>
                <tr><td><code>volunteer_times_available</code></td><td>Select</td><td>Times the applicant is available (e.g., Morning, Afternoon, Evening).</td></tr>
                <tr><td><code>volunteer_hours_per_week</code></td><td>Select</td><td>Hours per week the applicant can commit (e.g., 1-5, 6-10).</td></tr>
                <tr><td><code>volunteer_interests_skills</code></td><td>Checkbox</td><td>Applicant's interests and skills.</td></tr>
                <tr><td><code>volunteer_other_interests</code></td><td>Text Area</td><td>Other interests/skills not listed in checkboxes.</td></tr>
                <tr><td><code>volunteer_relevant_skills</code></td><td>Text Area</td><td>List of relevant skills, experience, or languages spoken.</td></tr>
                <tr><td><code>volunteer_why_volunteer</code></td><td>Text Area</td><td>Reason for wanting to volunteer.</td></tr>
                <tr><td><code>volunteer_emergency_fullname</code></td><td>Text</td><td>Emergency contact's full name.</td></tr>
                <tr><td><code>volunteer_emergency_relationship</code></td><td>Text</td><td>Emergency contact's relationship.</td></tr>
                <tr><td><code>volunteer_emergency_phone</code></td><td>Text</td><td>Emergency contact's phone number.</td></tr>
                <tr><td><code>volunteer_emergency_email</code></td><td>Email</td><td>Emergency contact's email address.</td></tr>
                <tr><td><code>volunteer_reference1_fullname</code></td><td>Text</td><td>Reference 1 full name.</td></tr>
                <tr><td><code>volunteer_reference1_relationship</code></td><td>Text</td><td>Reference 1 relationship.</td></tr>
                <tr><td><code>volunteer_reference1_phone</code></td><td>Text</td><td>Reference 1 phone.</td></tr>
                <tr><td><code>volunteer_reference1_email</code></td><td>Email</td><td>Reference 1 email.</td></tr>
                <tr><td><code>volunteer_reference2_fullname</code></td><td>Text</td><td>Reference 2 full name.</td></tr>
                <tr><td><code>volunteer_reference2_relationship</code></td><td>Text</td><td>Reference 2 relationship.</td></tr>
                <tr><td><code>volunteer_reference2_phone</code></td><td>Text</td><td>Reference 2 phone.</td></tr>
                <tr><td><code>volunteer_reference2_email</code></td><td>Email</td><td>Reference 2 email.</td></tr>
                <tr><td><code>volunteer_how_did_you_hear</code></td><td>Select</td><td>How the applicant heard about the organization.</td></tr>
                <tr><td><code>volunteer_age_18_or_older</code></td><td>Select</td><td>Confirmation if applicant is 18 or older.</td></tr>
                <tr><td><code>volunteer_background_check_consent</code></td><td>Select</td><td>Consent for background check.</td></tr>
                <tr><td><code>volunteer_medical_conditions</code></td><td>Text Area</td><td>Any medical conditions or physical limitations.</td></tr>
                <tr><td><code>volunteer_signature</code></td><td>Text</td><td>Applicant's signature.</td></tr>
                <tr><td><code>volunteer_submission_date</code></td><td>Date Picker</td><td>Date of application submission.</td></tr>
            </tbody>
        </table>

        <h2><?php _e('Email Notification Settings', 'bootstrap-volunteer-application'); ?></h2>
        <p><?php _e('You can configure the recipient email address for volunteer application notifications under the "Email Settings" submenu item.', 'bootstrap-volunteer-application'); ?></p>
    </div>
    <?php
}

/**
 * Add a dashboard widget to display the latest volunteer applications.
 */
add_action('wp_dashboard_setup', 'va_add_dashboard_widgets');
function va_add_dashboard_widgets() {
    // Check if ACF is active before adding the widget.
    if ( ! function_exists( 'get_field' ) ) {
        return; // Do not add the widget if ACF is not active.
    }

    // Query to check if there are any volunteer applications.
    $check_applications_query = new WP_Query( array(
        'post_type'      => 'volunteer',
        'posts_per_page' => 1, // Only need to check for one post to know if any exist.
        'post_status'    => 'publish',
        'fields'         => 'ids', // Only retrieve post IDs for efficiency.
    ) );

    if ( $check_applications_query->have_posts() ) {
        // If there are applications, add the dashboard widget.
        wp_add_dashboard_widget(
            'va_latest_volunteer_applications',         // Widget slug.
            __( 'Latest Volunteer Applications', 'bootstrap-volunteer-application' ), // Title.
            'va_latest_volunteer_applications_callback' // Display function.
        );
    }
    // No need for an else block; if no posts, the widget simply isn't added.
}

/**
 * Callback function to display the content of the dashboard widget.
 */
function va_latest_volunteer_applications_callback() {
    // Check if ACF is active before trying to get fields.
    if ( ! function_exists( 'get_field' ) ) {
        echo '<p>' . __( 'Advanced Custom Fields plugin is not active. Please install and activate it to view volunteer applications here.', 'bootstrap-volunteer-application' ) . '</p>';
        return;
    }

    // The number of items to show is now fixed at 3.
    $num_items = 3; 

    // Query the latest volunteer applications.
    $args = array(
        'post_type'      => 'volunteer',
        'posts_per_page' => $num_items,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC', // Latest to oldest
    );

    $volunteer_applications = new WP_Query( $args );

    if ( $volunteer_applications->have_posts() ) {
        echo '<ul class="va-dashboard-applications">';
        while ( $volunteer_applications->have_posts() ) {
            $volunteer_applications->the_post();
            $post_id = get_the_ID();
            $applicant_firstname = get_field( 'volunteer_firstname', $post_id );
            $applicant_lastname = get_field( 'volunteer_lastname', $post_id );
            $applicant_email = get_field( 'volunteer_email', $post_id );
            $applicant_country = get_field( 'volunteer_country', $post_id );
            $edit_post_link = get_edit_post_link( $post_id );

            echo '<li>';
            echo '<strong>' . esc_html( $applicant_firstname . ' ' . $applicant_lastname ) . '</strong>';
            echo ' (' . esc_html( $applicant_email ) . ')';
            echo '<br><strong>' . __( 'Country:', 'bootstrap-volunteer-application' ) . '</strong> ' . esc_html( $applicant_country );
            echo '<br><br><a href="' . esc_url( $edit_post_link ) . '" class="button button-primary button-small">' . __( 'View Application', 'bootstrap-volunteer-application' ) . '</a>';
            echo '<hr></li>';
        }
        echo '</ul>';
        wp_reset_postdata(); // Restore original Post Data
    } else {
        // This block will technically not be reached if the widget is only added when posts exist,
        // but it's good practice to have a fallback message if somehow it does.
        echo '<p>' . __( 'No volunteer applications found.', 'bootstrap-volunteer-application' ) . '</p>';
    }
}